<?php
require_once __DIR__ . '/auth.php';
requireLogin();
$settings = getSettings($pdo);
$siteName = $settings['site_name'] ?? 'TechSoft';
$adminPage = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - <?= htmlspecialchars($pageTitle ?? 'Panel') ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="/yazilim-sitesi/admin/assets/css/admin.css">
</head>
<body>
    <div class="admin-layout">
        <aside class="sidebar">
            <div class="sidebar-header">
                <h2><i class="fas fa-code"></i> Admin</h2>
            </div>
            <nav class="sidebar-nav">
                <a href="/yazilim-sitesi/admin/" class="<?= $adminPage === 'index' ? 'active' : '' ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
                <a href="/yazilim-sitesi/admin/services.php" class="<?= $adminPage === 'services' ? 'active' : '' ?>"><i class="fas fa-cogs"></i> Hizmetler</a>
                <a href="/yazilim-sitesi/admin/pricing.php" class="<?= $adminPage === 'pricing' ? 'active' : '' ?>"><i class="fas fa-tags"></i> Fiyatlandırma</a>
                <a href="/yazilim-sitesi/admin/portfolio.php" class="<?= $adminPage === 'portfolio' ? 'active' : '' ?>"><i class="fas fa-briefcase"></i> Portföy</a>
                <a href="/yazilim-sitesi/admin/testimonials.php" class="<?= $adminPage === 'testimonials' ? 'active' : '' ?>"><i class="fas fa-comments"></i> Yorumlar</a>
                <a href="/yazilim-sitesi/admin/messages.php" class="<?= $adminPage === 'messages' ? 'active' : '' ?>"><i class="fas fa-envelope"></i> Mesajlar</a>
                <a href="/yazilim-sitesi/admin/settings.php" class="<?= $adminPage === 'settings' ? 'active' : '' ?>"><i class="fas fa-sliders-h"></i> Ayarlar</a>
                <hr>
                <a href="/yazilim-sitesi/" target="_blank"><i class="fas fa-external-link-alt"></i> Siteyi Gör</a>
                <a href="/yazilim-sitesi/admin/logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
            </nav>
        </aside>
        <main class="admin-main">
            <div class="admin-topbar">
                <h1><?= htmlspecialchars($pageTitle ?? 'Dashboard') ?></h1>
            </div>
            <div class="admin-content">
