<?php $pageTitle = 'Mesajlar'; ?>
<?php require_once 'includes/header.php'; $csrf = generateCsrf(); ?>

<?php
if (isset($_GET['read']) && verifyCsrf($_GET['token'] ?? '')) {
    $pdo->prepare("UPDATE messages SET is_read = 1 WHERE id = ?")->execute([$_GET['read']]);
    header('Location: messages.php'); exit;
}
if (isset($_GET['unread']) && verifyCsrf($_GET['token'] ?? '')) {
    $pdo->prepare("UPDATE messages SET is_read = 0 WHERE id = ?")->execute([$_GET['unread']]);
    header('Location: messages.php'); exit;
}
if (isset($_GET['delete']) && verifyCsrf($_GET['token'] ?? '')) {
    $pdo->prepare("DELETE FROM messages WHERE id = ?")->execute([$_GET['delete']]);
    header('Location: messages.php?msg=deleted'); exit;
}

$view = null;
if (isset($_GET['view'])) {
    $stmt = $pdo->prepare("SELECT * FROM messages WHERE id = ?");
    $stmt->execute([$_GET['view']]);
    $view = $stmt->fetch();
    if ($view && !$view['is_read']) {
        $pdo->prepare("UPDATE messages SET is_read = 1 WHERE id = ?")->execute([$view['id']]);
    }
}
?>

<?php if (isset($_GET['msg'])): ?>
    <div class="alert alert-success">Silindi.</div>
<?php endif; ?>

<?php if ($view): ?>
<div class="form-card" style="max-width:800px;">
    <p><strong>Gönderen:</strong> <?= htmlspecialchars($view['name']) ?></p>
    <p><strong>E-posta:</strong> <?= htmlspecialchars($view['email']) ?></p>
    <p><strong>Telefon:</strong> <?= htmlspecialchars($view['phone']) ?></p>
    <p><strong>Konu:</strong> <?= htmlspecialchars($view['subject']) ?></p>
    <p><strong>Tarih:</strong> <?= $view['created_at'] ?></p>
    <hr style="margin:15px 0;">
    <p><?= nl2br(htmlspecialchars($view['message'])) ?></p>
    <div style="margin-top:20px;">
        <a href="messages.php" class="btn btn-secondary">Geri</a>
        <a href="messages.php?delete=<?= $view['id'] ?>&token=<?= $csrf ?>" class="btn btn-danger" onclick="return confirm('Silmek istediğinize emin misiniz?')">Sil</a>
    </div>
</div>
<?php else: ?>

<div class="table-wrap">
    <table>
        <thead><tr><th>Durum</th><th>Ad</th><th>E-posta</th><th>Konu</th><th>Tarih</th><th>İşlem</th></tr></thead>
        <tbody>
        <?php
        $stmt = $pdo->query("SELECT * FROM messages ORDER BY created_at DESC");
        while ($m = $stmt->fetch()):
        ?>
        <tr>
            <td><?= $m['is_read'] ? '<span class="badge badge-green">Okundu</span>' : '<span class="badge badge-red">Yeni</span>' ?></td>
            <td><?= htmlspecialchars($m['name']) ?></td>
            <td><?= htmlspecialchars($m['email']) ?></td>
            <td><?= htmlspecialchars($m['subject']) ?></td>
            <td><?= $m['created_at'] ?></td>
            <td class="actions">
                <a href="messages.php?view=<?= $m['id'] ?>" class="btn btn-sm btn-primary">Oku</a>
                <?php if ($m['is_read']): ?>
                    <a href="messages.php?unread=<?= $m['id'] ?>&token=<?= $csrf ?>" class="btn btn-sm btn-secondary">Okunmadı</a>
                <?php else: ?>
                    <a href="messages.php?read=<?= $m['id'] ?>&token=<?= $csrf ?>" class="btn btn-sm btn-success">Okundu</a>
                <?php endif; ?>
                <a href="messages.php?delete=<?= $m['id'] ?>&token=<?= $csrf ?>" class="btn btn-sm btn-danger" onclick="return confirm('Silmek istediğinize emin misiniz?')">Sil</a>
            </td>
        </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div>

<?php endif; ?>

<?php require_once 'includes/footer.php'; ?>
