<?php $pageTitle = 'Portföy'; ?>
<?php require_once 'includes/header.php'; $csrf = generateCsrf(); ?>

<?php
if (isset($_GET['delete']) && verifyCsrf($_GET['token'] ?? '')) {
    $pdo->prepare("DELETE FROM portfolio WHERE id = ?")->execute([$_GET['delete']]);
    header('Location: portfolio.php?msg=deleted'); exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && verifyCsrf($_POST['csrf_token'] ?? '')) {
    $data = [
        trim($_POST['title']),
        trim($_POST['description']),
        trim($_POST['image']),
        trim($_POST['client_name']),
        trim($_POST['project_url']),
        isset($_POST['is_active']) ? 1 : 0,
    ];
    if (!empty($_POST['id'])) {
        $data[] = $_POST['id'];
        $pdo->prepare("UPDATE portfolio SET title=?, description=?, image=?, client_name=?, project_url=?, is_active=? WHERE id=?")->execute($data);
    } else {
        $pdo->prepare("INSERT INTO portfolio (title, description, image, client_name, project_url, is_active) VALUES (?,?,?,?,?,?)")->execute($data);
    }
    header('Location: portfolio.php?msg=saved'); exit;
}

$edit = null;
if (isset($_GET['edit'])) {
    $stmt = $pdo->prepare("SELECT * FROM portfolio WHERE id = ?");
    $stmt->execute([$_GET['edit']]);
    $edit = $stmt->fetch();
}
?>

<?php if (isset($_GET['msg'])): ?>
    <div class="alert alert-success"><?= $_GET['msg'] === 'saved' ? 'Kaydedildi.' : 'Silindi.' ?></div>
<?php endif; ?>

<div class="form-card">
    <h3 style="margin-bottom:15px;"><?= $edit ? 'Düzenle' : 'Yeni Proje' ?></h3>
    <form method="POST">
        <input type="hidden" name="csrf_token" value="<?= $csrf ?>">
        <?php if ($edit): ?><input type="hidden" name="id" value="<?= $edit['id'] ?>"><?php endif; ?>
        <div class="form-group"><label>Proje Adı</label><input type="text" name="title" value="<?= htmlspecialchars($edit['title'] ?? '') ?>" required></div>
        <div class="form-group"><label>Açıklama</label><textarea name="description"><?= htmlspecialchars($edit['description'] ?? '') ?></textarea></div>
        <div class="form-row">
            <div class="form-group"><label>Müşteri</label><input type="text" name="client_name" value="<?= htmlspecialchars($edit['client_name'] ?? '') ?>"></div>
            <div class="form-group"><label>Proje URL</label><input type="text" name="project_url" value="<?= htmlspecialchars($edit['project_url'] ?? '') ?>"></div>
        </div>
        <div class="form-row">
            <div class="form-group"><label>Görsel URL</label><input type="text" name="image" value="<?= htmlspecialchars($edit['image'] ?? '') ?>"></div>
            <div class="form-group"><label><input type="checkbox" name="is_active" <?= ($edit['is_active'] ?? 1) ? 'checked' : '' ?>> Aktif</label></div>
        </div>
        <button type="submit" class="btn btn-primary">Kaydet</button>
        <?php if ($edit): ?><a href="portfolio.php" class="btn btn-secondary">İptal</a><?php endif; ?>
    </form>
</div>

<div class="table-wrap">
    <table>
        <thead><tr><th>Proje</th><th>Müşteri</th><th>Durum</th><th>İşlem</th></tr></thead>
        <tbody>
        <?php foreach ($pdo->query("SELECT * FROM portfolio ORDER BY created_at DESC") as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['title']) ?></td>
            <td><?= htmlspecialchars($row['client_name']) ?></td>
            <td><?= $row['is_active'] ? '<span class="badge badge-green">Aktif</span>' : '<span class="badge badge-red">Pasif</span>' ?></td>
            <td class="actions">
                <a href="portfolio.php?edit=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Düzenle</a>
                <a href="portfolio.php?delete=<?= $row['id'] ?>&token=<?= $csrf ?>" class="btn btn-sm btn-danger" onclick="return confirm('Silmek istediğinize emin misiniz?')">Sil</a>
            </td>
        </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php require_once 'includes/footer.php'; ?>
