<?php $pageTitle = 'Fiyatlandırma'; ?>
<?php require_once 'includes/header.php'; $csrf = generateCsrf(); ?>

<?php
if (isset($_GET['delete']) && verifyCsrf($_GET['token'] ?? '')) {
    $pdo->prepare("DELETE FROM pricing_plans WHERE id = ?")->execute([$_GET['delete']]);
    header('Location: pricing.php?msg=deleted'); exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && verifyCsrf($_POST['csrf_token'] ?? '')) {
    $features = array_filter(array_map('trim', explode("\n", $_POST['features'] ?? '')));
    $data = [
        trim($_POST['name']),
        floatval($_POST['price']),
        trim($_POST['period']),
        json_encode(array_values($features), JSON_UNESCAPED_UNICODE),
        isset($_POST['is_featured']) ? 1 : 0,
        intval($_POST['sort_order']),
    ];
    if (!empty($_POST['id'])) {
        $data[] = $_POST['id'];
        $pdo->prepare("UPDATE pricing_plans SET name=?, price=?, period=?, features=?, is_featured=?, sort_order=? WHERE id=?")->execute($data);
    } else {
        $pdo->prepare("INSERT INTO pricing_plans (name, price, period, features, is_featured, sort_order) VALUES (?,?,?,?,?,?)")->execute($data);
    }
    header('Location: pricing.php?msg=saved'); exit;
}

$edit = null;
if (isset($_GET['edit'])) {
    $stmt = $pdo->prepare("SELECT * FROM pricing_plans WHERE id = ?");
    $stmt->execute([$_GET['edit']]);
    $edit = $stmt->fetch();
}
$editFeatures = '';
if ($edit) {
    $f = json_decode($edit['features'], true) ?: [];
    $editFeatures = implode("\n", $f);
}
?>

<?php if (isset($_GET['msg'])): ?>
    <div class="alert alert-success"><?= $_GET['msg'] === 'saved' ? 'Kaydedildi.' : 'Silindi.' ?></div>
<?php endif; ?>

<div class="form-card">
    <h3 style="margin-bottom:15px;"><?= $edit ? 'Düzenle' : 'Yeni Paket' ?></h3>
    <form method="POST">
        <input type="hidden" name="csrf_token" value="<?= $csrf ?>">
        <?php if ($edit): ?><input type="hidden" name="id" value="<?= $edit['id'] ?>"><?php endif; ?>
        <div class="form-group"><label>Paket Adı</label><input type="text" name="name" value="<?= htmlspecialchars($edit['name'] ?? '') ?>" required></div>
        <div class="form-row">
            <div class="form-group"><label>Fiyat (₺)</label><input type="number" name="price" step="0.01" value="<?= $edit['price'] ?? 0 ?>" required></div>
            <div class="form-group"><label>Periyot</label><input type="text" name="period" value="<?= htmlspecialchars($edit['period'] ?? 'ay') ?>"></div>
        </div>
        <div class="form-group"><label>Özellikler (her satıra bir tane)</label><textarea name="features" rows="6"><?= htmlspecialchars($editFeatures) ?></textarea></div>
        <div class="form-row">
            <div class="form-group"><label>Sıra</label><input type="number" name="sort_order" value="<?= $edit['sort_order'] ?? 0 ?>"></div>
            <div class="form-group"><label><input type="checkbox" name="is_featured" <?= ($edit['is_featured'] ?? 0) ? 'checked' : '' ?>> Öne Çıkan</label></div>
        </div>
        <button type="submit" class="btn btn-primary">Kaydet</button>
        <?php if ($edit): ?><a href="pricing.php" class="btn btn-secondary">İptal</a><?php endif; ?>
    </form>
</div>

<div class="table-wrap">
    <table>
        <thead><tr><th>Sıra</th><th>Paket</th><th>Fiyat</th><th>Öne Çıkan</th><th>İşlem</th></tr></thead>
        <tbody>
        <?php foreach ($pdo->query("SELECT * FROM pricing_plans ORDER BY sort_order") as $row): ?>
        <tr>
            <td><?= $row['sort_order'] ?></td>
            <td><?= htmlspecialchars($row['name']) ?></td>
            <td><?= number_format($row['price'], 0, ',', '.') ?> ₺ / <?= htmlspecialchars($row['period']) ?></td>
            <td><?= $row['is_featured'] ? '<span class="badge badge-yellow">Evet</span>' : 'Hayır' ?></td>
            <td class="actions">
                <a href="pricing.php?edit=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Düzenle</a>
                <a href="pricing.php?delete=<?= $row['id'] ?>&token=<?= $csrf ?>" class="btn btn-sm btn-danger" onclick="return confirm('Silmek istediğinize emin misiniz?')">Sil</a>
            </td>
        </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php require_once 'includes/footer.php'; ?>
