<?php $pageTitle = 'Hizmetler'; ?>
<?php require_once 'includes/header.php'; $csrf = generateCsrf(); ?>

<?php
// Delete
if (isset($_GET['delete']) && verifyCsrf($_GET['token'] ?? '')) {
    $pdo->prepare("DELETE FROM services WHERE id = ?")->execute([$_GET['delete']]);
    header('Location: services.php?msg=deleted'); exit;
}

// Save
if ($_SERVER['REQUEST_METHOD'] === 'POST' && verifyCsrf($_POST['csrf_token'] ?? '')) {
    $data = [
        trim($_POST['title']),
        trim($_POST['description']),
        trim($_POST['icon']),
        floatval($_POST['price']),
        isset($_POST['is_active']) ? 1 : 0,
        intval($_POST['sort_order']),
    ];
    if (!empty($_POST['id'])) {
        $data[] = $_POST['id'];
        $pdo->prepare("UPDATE services SET title=?, description=?, icon=?, price=?, is_active=?, sort_order=? WHERE id=?")->execute($data);
    } else {
        $pdo->prepare("INSERT INTO services (title, description, icon, price, is_active, sort_order) VALUES (?,?,?,?,?,?)")->execute($data);
    }
    header('Location: services.php?msg=saved'); exit;
}

$edit = null;
if (isset($_GET['edit'])) {
    $stmt = $pdo->prepare("SELECT * FROM services WHERE id = ?");
    $stmt->execute([$_GET['edit']]);
    $edit = $stmt->fetch();
}
?>

<?php if (isset($_GET['msg'])): ?>
    <div class="alert alert-success"><?= $_GET['msg'] === 'saved' ? 'Kaydedildi.' : 'Silindi.' ?></div>
<?php endif; ?>

<div class="form-card">
    <h3 style="margin-bottom:15px;"><?= $edit ? 'Düzenle' : 'Yeni Hizmet' ?></h3>
    <form method="POST">
        <input type="hidden" name="csrf_token" value="<?= $csrf ?>">
        <?php if ($edit): ?><input type="hidden" name="id" value="<?= $edit['id'] ?>"><?php endif; ?>
        <div class="form-group"><label>Başlık</label><input type="text" name="title" value="<?= htmlspecialchars($edit['title'] ?? '') ?>" required></div>
        <div class="form-group"><label>Açıklama</label><textarea name="description"><?= htmlspecialchars($edit['description'] ?? '') ?></textarea></div>
        <div class="form-row">
            <div class="form-group"><label>İkon (Font Awesome)</label><input type="text" name="icon" value="<?= htmlspecialchars($edit['icon'] ?? 'fas fa-code') ?>"></div>
            <div class="form-group"><label>Fiyat (₺)</label><input type="number" name="price" step="0.01" value="<?= $edit['price'] ?? 0 ?>"></div>
        </div>
        <div class="form-row">
            <div class="form-group"><label>Sıra</label><input type="number" name="sort_order" value="<?= $edit['sort_order'] ?? 0 ?>"></div>
            <div class="form-group"><label><input type="checkbox" name="is_active" <?= ($edit['is_active'] ?? 1) ? 'checked' : '' ?>> Aktif</label></div>
        </div>
        <button type="submit" class="btn btn-primary">Kaydet</button>
        <?php if ($edit): ?><a href="services.php" class="btn btn-secondary">İptal</a><?php endif; ?>
    </form>
</div>

<div class="table-wrap">
    <table>
        <thead><tr><th>Sıra</th><th>Başlık</th><th>Fiyat</th><th>Durum</th><th>İşlem</th></tr></thead>
        <tbody>
        <?php foreach ($pdo->query("SELECT * FROM services ORDER BY sort_order") as $row): ?>
        <tr>
            <td><?= $row['sort_order'] ?></td>
            <td><i class="<?= htmlspecialchars($row['icon']) ?>"></i> <?= htmlspecialchars($row['title']) ?></td>
            <td><?= number_format($row['price'], 0, ',', '.') ?> ₺</td>
            <td><?= $row['is_active'] ? '<span class="badge badge-green">Aktif</span>' : '<span class="badge badge-red">Pasif</span>' ?></td>
            <td class="actions">
                <a href="services.php?edit=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Düzenle</a>
                <a href="services.php?delete=<?= $row['id'] ?>&token=<?= $csrf ?>" class="btn btn-sm btn-danger" onclick="return confirm('Silmek istediğinize emin misiniz?')">Sil</a>
            </td>
        </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php require_once 'includes/footer.php'; ?>
