<?php $pageTitle = 'Ayarlar'; ?>
<?php require_once 'includes/header.php'; $csrf = generateCsrf(); ?>

<?php
$saved = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && verifyCsrf($_POST['csrf_token'] ?? '')) {
    $keys = ['site_name', 'site_description', 'email', 'phone', 'address', 'footer_text'];
    foreach ($keys as $key) {
        $value = trim($_POST[$key] ?? '');
        $stmt = $pdo->prepare("INSERT INTO settings (`key`, value) VALUES (?, ?) ON DUPLICATE KEY UPDATE value = ?");
        $stmt->execute([$key, $value, $value]);
    }
    $saved = true;
    $settings = getSettings($pdo);
}
?>

<?php if ($saved): ?><div class="alert alert-success">Ayarlar kaydedildi.</div><?php endif; ?>

<div class="form-card" style="max-width:600px;">
    <form method="POST">
        <input type="hidden" name="csrf_token" value="<?= $csrf ?>">
        <div class="form-group"><label>Site Adı</label><input type="text" name="site_name" value="<?= htmlspecialchars($settings['site_name'] ?? '') ?>"></div>
        <div class="form-group"><label>Site Açıklaması</label><input type="text" name="site_description" value="<?= htmlspecialchars($settings['site_description'] ?? '') ?>"></div>
        <div class="form-group"><label>E-posta</label><input type="email" name="email" value="<?= htmlspecialchars($settings['email'] ?? '') ?>"></div>
        <div class="form-group"><label>Telefon</label><input type="text" name="phone" value="<?= htmlspecialchars($settings['phone'] ?? '') ?>"></div>
        <div class="form-group"><label>Adres</label><textarea name="address"><?= htmlspecialchars($settings['address'] ?? '') ?></textarea></div>
        <div class="form-group"><label>Footer Metni</label><input type="text" name="footer_text" value="<?= htmlspecialchars($settings['footer_text'] ?? '') ?>"></div>
        <button type="submit" class="btn btn-primary">Kaydet</button>
    </form>
</div>

<?php require_once 'includes/footer.php'; ?>
