<?php
require_once __DIR__ . '/../config/db.php';
$settings = getSettings($pdo);
$siteName = $settings['site_name'] ?? 'TechSoft';
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle ?? $siteName) ?> - <?= htmlspecialchars($siteName) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="/yazilim-sitesi/assets/css/style.css">
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <a href="/yazilim-sitesi/" class="logo">
                <i class="fas fa-code"></i> <?= htmlspecialchars($siteName) ?>
            </a>
            <button class="nav-toggle" aria-label="Menü"><i class="fas fa-bars"></i></button>
            <ul class="nav-links">
                <li><a href="/yazilim-sitesi/" class="<?= $currentPage === 'index' ? 'active' : '' ?>">Ana Sayfa</a></li>
                <li><a href="/yazilim-sitesi/hizmetler.php" class="<?= $currentPage === 'hizmetler' ? 'active' : '' ?>">Hizmetler</a></li>
                <li><a href="/yazilim-sitesi/portfolyo.php" class="<?= $currentPage === 'portfolyo' ? 'active' : '' ?>">Portföy</a></li>
                <li><a href="/yazilim-sitesi/iletisim.php" class="<?= $currentPage === 'iletisim' ? 'active' : '' ?>">İletişim</a></li>
            </ul>
        </div>
    </nav>
