<?php $pageTitle = 'Ana Sayfa'; ?>
<?php require_once 'includes/header.php'; ?>

<section class="hero">
    <div class="container">
        <h1>Yazılım Çözümleriniz İçin Doğru Adres</h1>
        <p>Modern teknolojilerle işletmenizi dijital dünyada öne çıkarıyoruz.</p>
        <a href="/yazilim-sitesi/iletisim.php" class="btn btn-primary">Teklif Alın</a>
    </div>
</section>

<section class="section">
    <div class="container">
        <div class="section-title">
            <h2>Hizmetlerimiz</h2>
            <p>İşletmenizi büyütecek yazılım çözümleri sunuyoruz</p>
        </div>
        <div class="grid-3">
            <?php
            $stmt = $pdo->query("SELECT * FROM services WHERE is_active = 1 ORDER BY sort_order LIMIT 6");
            while ($s = $stmt->fetch()):
            ?>
            <div class="card">
                <div class="icon"><i class="<?= htmlspecialchars($s['icon']) ?>"></i></div>
                <h3><?= htmlspecialchars($s['title']) ?></h3>
                <p><?= htmlspecialchars($s['description']) ?></p>
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>

<section class="section section-light">
    <div class="container">
        <div class="section-title">
            <h2>Müşteri Yorumları</h2>
            <p>Müşterilerimiz ne diyor?</p>
        </div>
        <div class="grid-3">
            <?php
            $stmt = $pdo->query("SELECT * FROM testimonials WHERE is_active = 1 ORDER BY created_at DESC LIMIT 3");
            while ($t = $stmt->fetch()):
            ?>
            <div class="testimonial-card">
                <div class="stars">
                    <?php for ($i = 0; $i < $t['rating']; $i++): ?><i class="fas fa-star"></i><?php endfor; ?>
                </div>
                <p class="comment">"<?= htmlspecialchars($t['comment']) ?>"</p>
                <p class="author"><?= htmlspecialchars($t['client_name']) ?></p>
                <p class="title"><?= htmlspecialchars($t['client_title']) ?></p>
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>

<section class="cta">
    <div class="container">
        <h2>Projenizi Hayata Geçirelim</h2>
        <p>Hemen bizimle iletişime geçin, ücretsiz danışmanlık alın.</p>
        <a href="/yazilim-sitesi/iletisim.php" class="btn btn-primary">İletişime Geçin</a>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>
