<?php $pageTitle = 'Portföy'; ?>
<?php require_once 'includes/header.php'; ?>

<section class="section">
    <div class="container">
        <div class="section-title">
            <h2>Projelerimiz</h2>
            <p>Tamamladığımız başarılı projeler</p>
        </div>
        <div class="grid-3">
            <?php
            $stmt = $pdo->query("SELECT * FROM portfolio WHERE is_active = 1 ORDER BY created_at DESC");
            while ($p = $stmt->fetch()):
            ?>
            <div class="portfolio-card">
                <div class="portfolio-img"><i class="fas fa-laptop-code"></i></div>
                <div class="portfolio-info">
                    <h3><?= htmlspecialchars($p['title']) ?></h3>
                    <p><?= htmlspecialchars($p['description']) ?></p>
                    <p class="client"><i class="fas fa-user"></i> <?= htmlspecialchars($p['client_name']) ?></p>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>

<section class="section section-light">
    <div class="container">
        <div class="section-title">
            <h2>Müşteri Yorumları</h2>
            <p>Müşterilerimizin deneyimleri</p>
        </div>
        <div class="grid-3">
            <?php
            $stmt = $pdo->query("SELECT * FROM testimonials WHERE is_active = 1 ORDER BY created_at DESC");
            while ($t = $stmt->fetch()):
            ?>
            <div class="testimonial-card">
                <div class="stars">
                    <?php for ($i = 0; $i < $t['rating']; $i++): ?><i class="fas fa-star"></i><?php endfor; ?>
                </div>
                <p class="comment">"<?= htmlspecialchars($t['comment']) ?>"</p>
                <p class="author"><?= htmlspecialchars($t['client_name']) ?></p>
                <p class="title"><?= htmlspecialchars($t['client_title']) ?></p>
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>
